/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay.bookmarks.history;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.gui.bookmarks.IBookmark;
import mezz.jei.gui.config.ILookupHistoryConfig;
import mezz.jei.gui.overlay.IIngredientGridSource;
import mezz.jei.gui.overlay.elements.IElement;
import org.jetbrains.annotations.Unmodifiable;

public class LookupHistory
implements IIngredientGridSource {
    private final List<IBookmark> elements = new LinkedList<IBookmark>();
    private final List<IIngredientGridSource.SourceListChangedListener> listeners = new ArrayList<IIngredientGridSource.SourceListChangedListener>();
    private final IRecipeManager recipeManager;
    private final IIngredientManager ingredientManager;
    private final IFocusFactory focusFactory;
    private final Supplier<Integer> maxElements;
    private final ILookupHistoryConfig lookupHistoryConfig;

    public LookupHistory(IRecipeManager recipeManager, IIngredientManager ingredientManager, IFocusFactory focusFactory, Supplier<Integer> maxElements, ILookupHistoryConfig lookupHistoryConfig) {
        this.recipeManager = recipeManager;
        this.ingredientManager = ingredientManager;
        this.focusFactory = focusFactory;
        this.maxElements = maxElements;
        this.lookupHistoryConfig = lookupHistoryConfig;
        List<IBookmark> loaded = lookupHistoryConfig.load(recipeManager, ingredientManager, focusFactory);
        this.elements.addAll(loaded);
    }

    public void add(IBookmark element) {
        this.elements.remove(element);
        this.elements.add(0, element);
        if (this.elements.size() > this.maxElements.get()) {
            this.elements.remove(this.elements.size() - 1);
        }
        this.notifyListeners();
        this.lookupHistoryConfig.save(this.recipeManager, this.ingredientManager, this.focusFactory, this.elements);
    }

    @Override
    public @Unmodifiable List<IElement<?>> getElements() {
        return this.elements.stream().map(IBookmark::getElement).toList();
    }

    @Override
    public void addSourceListChangedListener(IIngredientGridSource.SourceListChangedListener listener) {
        this.listeners.add(listener);
    }

    private void notifyListeners() {
        for (IIngredientGridSource.SourceListChangedListener listener : this.listeners) {
            listener.onSourceListChanged();
        }
    }
}

