/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import java.util.Arrays;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.ManaTrigger;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;

public class AnimatedTorchBlockEntity
extends BotaniaBlockEntity
implements ManaTrigger,
Wandable {
    private static final String TAG_SIDE = "side";
    private static final String TAG_ROTATING = "rotating";
    private static final String TAG_ROTATION_TICKS = "rotationTicks";
    private static final String TAG_ANGLE_PER_TICK = "anglePerTick";
    private static final String TAG_TORCH_MODE = "torchMode";
    private static final String TAG_NEXT_RANDOM_ROTATION = "nextRandomRotation";
    public static final Direction[] SIDES = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    public int side;
    public double rotation;
    public boolean rotating;
    public boolean directionInitialized;
    public double lastTickRotation;
    public int nextRandomRotation = Mth.m_14107_((double)(Math.random() * 3.0));
    public int currentRandomRotation;
    private int rotationTicks;
    public double anglePerTick;
    private TorchMode torchMode = TorchMode.TOGGLE;

    public AnimatedTorchBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.ANIMATED_TORCH, pos, state);
    }

    public void handRotate() {
        if (!this.f_58857_.f_46443_) {
            this.f_58857_.m_7696_(this.m_58899_(), BotaniaBlocks.animatedTorch, 0, (this.side + 1) % 4);
        }
    }

    public void onPlace(@Nullable LivingEntity entity) {
        if (entity != null) {
            this.side = Arrays.asList(SIDES).indexOf(entity.m_6350_().m_122424_());
        }
        this.directionInitialized = true;
        AnimatedTorchBlockEntity.updateNeighbors(this.f_58857_, this.f_58858_, this.m_58900_(), this.side);
    }

    public void m_7651_() {
        this.directionInitialized = false;
        super.m_7651_();
    }

    public void toggle() {
        if (!this.f_58857_.f_46443_) {
            this.f_58857_.m_7696_(this.m_58899_(), BotaniaBlocks.animatedTorch, 0, this.torchMode.modeSwitcher.rotate(this, this.side));
            this.nextRandomRotation = this.f_58857_.f_46441_.m_188503_(4);
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    @Override
    public boolean onUsedByWand(Player player, ItemStack stack, Direction side) {
        int modeOrdinal = this.torchMode.ordinal();
        TorchMode[] modes = TorchMode.values();
        this.torchMode = modes[(modeOrdinal + 1) % modes.length];
        return true;
    }

    public boolean m_7531_(int id, int param) {
        if (id == 0) {
            this.rotateTo(param);
            return true;
        }
        return super.m_7531_(id, param);
    }

    private void rotateTo(int side) {
        if (this.rotating) {
            return;
        }
        this.currentRandomRotation = this.nextRandomRotation;
        int finalRotation = side * 90;
        double diff = ((double)finalRotation - this.rotation % 360.0) % 360.0;
        if (diff < 0.0) {
            diff = 360.0 + diff;
        }
        this.rotationTicks = 4;
        this.anglePerTick = diff / (double)this.rotationTicks;
        int oldSide = this.side;
        this.side = side;
        this.rotating = true;
        AnimatedTorchBlockEntity.updateNeighbors(this.f_58857_, this.f_58858_, this.m_58900_(), oldSide);
    }

    @Override
    public void onBurstCollision(ManaBurst burst) {
        if (!burst.isFake()) {
            this.toggle();
        }
    }

    public static void commonTick(Level level, BlockPos worldPosition, BlockState state, AnimatedTorchBlockEntity self) {
        if (!self.directionInitialized) {
            self.directionInitialized = true;
        }
        if (self.rotating) {
            self.lastTickRotation = self.rotation;
            self.rotation = (self.rotation + self.anglePerTick) % 360.0;
            --self.rotationTicks;
            if (self.rotationTicks <= 0) {
                self.rotating = false;
                AnimatedTorchBlockEntity.updateNeighbors(level, worldPosition, state, self.side);
            }
        } else {
            self.rotation = self.side * 90;
        }
        if (level.f_46443_) {
            int amt = self.rotating ? 3 : (Math.random() < 0.1 ? 1 : 0);
            double x = (double)worldPosition.m_123341_() + 0.5 + Math.cos((self.rotation + 90.0) / 180.0 * Math.PI) * 0.35;
            double y = (double)worldPosition.m_123342_() + 0.2;
            double z = (double)worldPosition.m_123343_() + 0.5 + Math.sin((self.rotation + 90.0) / 180.0 * Math.PI) * 0.35;
            for (int i = 0; i < amt; ++i) {
                level.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    private static void updateNeighbors(Level level, BlockPos worldPosition, BlockState state, int self) {
        level.m_46672_(worldPosition, state.m_60734_());
        BlockPos targetPos = worldPosition.m_121945_(SIDES[self].m_122424_());
        level.m_46590_(targetPos, level.m_8055_(targetPos).m_60734_(), SIDES[self]);
    }

    @Override
    public void writePacketNBT(CompoundTag cmp) {
        cmp.m_128405_(TAG_SIDE, this.side);
        cmp.m_128379_(TAG_ROTATING, this.rotating);
        cmp.m_128405_(TAG_ROTATION_TICKS, this.rotationTicks);
        cmp.m_128347_(TAG_ANGLE_PER_TICK, this.anglePerTick);
        cmp.m_128405_(TAG_TORCH_MODE, this.torchMode.ordinal());
        cmp.m_128405_(TAG_NEXT_RANDOM_ROTATION, this.nextRandomRotation);
    }

    @Override
    public void readPacketNBT(CompoundTag cmp) {
        this.side = cmp.m_128451_(TAG_SIDE);
        this.rotating = cmp.m_128471_(TAG_ROTATING);
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.rotationTicks = cmp.m_128451_(TAG_ROTATION_TICKS);
        }
        this.anglePerTick = cmp.m_128459_(TAG_ANGLE_PER_TICK);
        this.nextRandomRotation = cmp.m_128451_(TAG_NEXT_RANDOM_ROTATION);
        int modeOrdinal = cmp.m_128451_(TAG_TORCH_MODE);
        TorchMode[] modes = TorchMode.values();
        this.torchMode = modes[modeOrdinal % modes.length];
    }

    public static enum TorchMode {
        TOGGLE((t, i) -> (i + 2) % 4),
        ROTATE((t, i) -> (i + 1) % 4),
        RANDOM((t, i) -> t.currentRandomRotation);

        public final RotationHandler modeSwitcher;

        private TorchMode(RotationHandler modeSwitcher) {
            this.modeSwitcher = modeSwitcher;
        }

        private static interface RotationHandler {
            public int rotate(AnimatedTorchBlockEntity var1, int var2);
        }
    }

    public static class WandHud
    implements WandHUD {
        private final AnimatedTorchBlockEntity torch;

        public WandHud(AnimatedTorchBlockEntity torch) {
            this.torch = torch;
        }

        @Override
        public void renderHUD(GuiGraphics gui, Minecraft mc) {
            int x = mc.m_91268_().m_85445_() / 2 + 8;
            int y = mc.m_91268_().m_85446_() / 2 - 10;
            String str = I18n.m_118938_((String)("botania.animatedTorch." + this.torch.torchMode.name().toLowerCase(Locale.ROOT)), (Object[])new Object[0]);
            RenderHelper.renderHUDBox(gui, x, y, x + 18 + mc.f_91062_.m_92895_(str), y + 20);
            gui.m_280203_(new ItemStack((ItemLike)Blocks.f_50174_), x, y + 2);
            gui.m_280488_(mc.f_91062_, str, x + 16, y + 6, 0xFF4444);
        }
    }
}

