/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import com.google.common.base.Suppliers;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.mana.BasicLensItem;
import vazkii.botania.common.crafting.recipe.NoOpRecipeSerializer;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.lens.LensItem;

public class LensDyeingRecipe
extends CustomRecipe {
    public static final NoOpRecipeSerializer<LensDyeingRecipe> SERIALIZER = new NoOpRecipeSerializer<LensDyeingRecipe>(LensDyeingRecipe::new);
    private final Supplier<List<Ingredient>> dyes = Suppliers.memoize(() -> Arrays.asList(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42535_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42536_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42537_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42538_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42539_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42540_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42489_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42490_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42491_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42492_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42493_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42494_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42495_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42496_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42497_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42498_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{BotaniaItems.manaPearl})));

    public LensDyeingRecipe(ResourceLocation id) {
        super(id, CraftingBookCategory.REDSTONE);
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level world) {
        boolean foundLens = false;
        boolean foundDye = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof BasicLensItem && !foundLens) {
                foundLens = true;
                continue;
            }
            if (!foundDye) {
                int color = this.getStackColor(stack);
                if (color > -1) {
                    foundDye = true;
                    continue;
                }
                return false;
            }
            return false;
        }
        return foundLens && foundDye;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, @NotNull RegistryAccess registries) {
        ItemStack lens = ItemStack.f_41583_;
        int color = -1;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof BasicLensItem && lens.m_41619_()) {
                lens = stack;
                continue;
            }
            color = this.getStackColor(stack);
        }
        if (lens.m_41720_() instanceof BasicLensItem) {
            ItemStack lensCopy = lens.m_255036_(1);
            LensItem.setLensColor(lensCopy, color);
            return lensCopy;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    private int getStackColor(ItemStack stack) {
        List<Ingredient> dyes = this.dyes.get();
        for (int i = 0; i < dyes.size(); ++i) {
            if (!dyes.get(i).test(stack)) continue;
            return i;
        }
        return -1;
    }
}

