/*
 * Decompiled with CFR 0.152.
 */
package com.connectivity.networkstats;

import com.connectivity.Connectivity;
import com.connectivity.config.CommonConfiguration;
import com.google.common.util.concurrent.AtomicDouble;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class MalformedTrafficTracker {
    private static final Set<String> BLOCKED = ConcurrentHashMap.newKeySet();
    private static final Set<String> LOGGED_IN_IPS = ConcurrentHashMap.newKeySet();
    private static final ConcurrentMap<String, Integer> errorCounts = new ConcurrentHashMap<String, Integer>();
    private static final AtomicInteger ERROR_COUNT = new AtomicInteger();
    private static final AtomicLong LAST_ERROR_RATE_UPDATE = new AtomicLong();
    private static final AtomicDouble ERROR_RATE_PER_SEC = new AtomicDouble();
    public static final AtomicInteger ACTIVE_CHANNELS = new AtomicInteger();
    public static final AttributeKey<String> FROZEN = AttributeKey.valueOf((String)"frozen");

    public static boolean isBlocked(ChannelHandlerContext ctx) {
        if (!((CommonConfiguration)Connectivity.config.getCommonConfig()).enableMalformedTrafficDetection) {
            return false;
        }
        return BLOCKED.contains(MalformedTrafficTracker.getIdentifier(ctx.channel()));
    }

    public static void removedBlocked(String identifier) {
        BLOCKED.remove(identifier);
    }

    public static void recordError(ChannelHandlerContext ctx) {
        int count;
        String identifier = MalformedTrafficTracker.getIdentifier(ctx.channel());
        if (LOGGED_IN_IPS.contains(identifier) || BLOCKED.contains(identifier)) {
            return;
        }
        ERROR_COUNT.incrementAndGet();
        long now = System.currentTimeMillis();
        long last = LAST_ERROR_RATE_UPDATE.get();
        long elapsed = now - last;
        if (elapsed > 1000L && LAST_ERROR_RATE_UPDATE.compareAndSet(last, now)) {
            count = ERROR_COUNT.getAndSet(0);
            double rate = (double)count * 1000.0 / (double)elapsed;
            ERROR_RATE_PER_SEC.set((ERROR_RATE_PER_SEC.get() * 9.0 + rate) / 10.0);
        }
        if ((double)(count = errorCounts.merge(identifier, 1, Integer::sum).intValue()) >= MalformedTrafficTracker.calculateThreshold()) {
            BLOCKED.add(identifier);
            errorCounts.remove(identifier);
            Connectivity.LOGGER.warn("Ignoring further traffic from: " + identifier + " for repeated malformed traffic.");
            MalformedTrafficTracker.closeChannel(ctx);
        }
    }

    private static double calculateThreshold() {
        double rate = ERROR_RATE_PER_SEC.get();
        int threshold = (int)Math.ceil(25.0 / (1.0 + rate / 2.0));
        return Math.max(3, Math.min(threshold, 25));
    }

    public static void onLogin(Channel channel) {
        LOGGED_IN_IPS.add(MalformedTrafficTracker.getIdentifier(channel));
        errorCounts.remove(MalformedTrafficTracker.getIdentifier(channel));
    }

    private static void closeChannel(ChannelHandlerContext ctx) {
        ctx.channel().config().setOption(ChannelOption.AUTO_READ, (Object)false);
        ctx.pipeline().remove(ReadTimeoutHandler.class);
        String identifier = ((InetSocketAddress)ctx.channel().remoteAddress()).getAddress().getHostAddress();
        if (((CommonConfiguration)Connectivity.config.getCommonConfig()).proxyWhitelist.contains(identifier)) {
            MalformedTrafficTracker.freezeChannel(ctx, 60);
        } else {
            ctx.close();
        }
    }

    public static void freezeChannel(ChannelHandlerContext ctx, int secondsTimeout) {
        if (!ctx.channel().hasAttr(FROZEN)) {
            ctx.channel().config().setOption(ChannelOption.AUTO_READ, (Object)false);
            ctx.channel().config().setOption(ChannelOption.SO_RCVBUF, (Object)16384);
            ctx.channel().config().setOption(ChannelOption.SO_SNDBUF, (Object)16384);
            ctx.channel().attr(FROZEN).set((Object)"true");
            ctx.executor().schedule(() -> {
                if (ctx.channel().isOpen()) {
                    ctx.close();
                }
            }, (long)secondsTimeout, TimeUnit.SECONDS);
        }
    }

    private static String getIdentifier(Channel channel) {
        SocketAddress adr = channel.remoteAddress();
        if (!(adr instanceof InetSocketAddress)) {
            return "local:" + adr;
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)adr;
        String identifier = inetSocketAddress.getAddress().getHostAddress();
        if (((CommonConfiguration)Connectivity.config.getCommonConfig()).proxyWhitelist.contains(identifier)) {
            identifier = channel.toString();
        }
        return identifier;
    }

    public static int freezeTimeoutSeconds() {
        int channels = ACTIVE_CHANNELS.get();
        if (channels < 2000) {
            return 30;
        }
        if (channels < 3000) {
            return 15;
        }
        if (channels < 5000) {
            return 7;
        }
        return 3;
    }
}

